$(function(){
    
	//open the deletion dialog when the delete user link clicked
	$("#vu_action_delete").on('click',function(){	
		var user_id  	 = $("#vu_details").data("userid");
		var csrf_token   = $("#vu_details").data("csrftoken");
		var current_user = [{ name : "entry_" + user_id, value : "1"}];

		Swal.fire({
				title: 'Are you sure you want to delete this user?',
				html: 'This user will be deleted and subsequently blocked.',
				footer: 'This action cannot be undone.',
				icon: 'warning',
				width: '40%',
				customClass: {
					htmlContainer: 'swal2-html-container-bold swal2-html-container-padding-bottom',
					footer: 'swal2-footer-warning',
					title: 'swal2-title-warning'
				},
				showCancelButton: true,
				confirmButtonText: 'Yes. Delete this user',
				showLoaderOnConfirm: true,
				preConfirm: () => {
					return axios.post('change_user_status.php', {
						action: 'delete',
						origin: 'view_user',
						csrf_token: csrf_token,
						selected_users: current_user
					})
					.then(function (response) {
						if(response.data.status == 'ok'){
							return response;
						}else{
							Swal.showValidationMessage('Error: Unable to process. Please try again later.');
						}
					})
					.catch(function (error) {
						Swal.showValidationMessage("Error: " + error);
					})
				},
				allowOutsideClick: () => !Swal.isLoading()
		}).then((result) => {
				if(result.isConfirmed) {
					//redirect to user manager
					window.location.replace('manage_users.php');
				}
		});

		return false;
	});

	//suspend/unspend user when the suspend link being clicked
	$("#vu_action_suspend").on('click',function(){

		if($(this).data('processing') !== true){
			$(this).data('processing',true);

			if($(this).hasClass('unsuspend')){
				
				//unsuspend the user
				$(this).removeClass('unsuspend').append(' <img src="images/loader_small_grey.gif" style="vertical-align: middle" />');

				//do the ajax call to unsuspend the user
				var user_id  	 = $("#vu_details").data("userid");
				var csrf_token   = $("#vu_details").data("csrftoken");
				var current_user = [{ name : "entry_" + user_id, value : "1"}];
					
				//do the ajax call to unsuspend the users
				axios.post('change_user_status.php', {
					action: 'unsuspend',
					csrf_token: csrf_token,
					selected_users: current_user
				})
				.then(function (response) {
					if(response.data.status == 'ok'){
						$("#vu_action_suspend").data("processing",false);
						$("#vu_action_suspend").html('<span class="icon-user-block"></span>Suspend');
						$("#vu_suspended").fadeOut(function(){
							$(this).remove();
						});
					}else{
						Swal.fire({
							width: '30%',
							position: 'center',
							icon: 'error',
							title: 'Error. Unable to complete the task.',
							html: response.data,
							showConfirmButton: false,
							showCancelButton: true,
							cancelButtonText: 'Close',
							allowOutsideClick: true
						});
					}
				})
				.catch(function (error) {
					Swal.fire({
						width: '30%',
						position: 'center',
						icon: 'error',
						title: 'Error. Unable to complete the task.',
						html: error,
						showConfirmButton: false,
						showCancelButton: true,
						cancelButtonText: 'Close',
						allowOutsideClick: true
					});
				});
			}else{
				//suspend the user
				$(this).addClass('unsuspend').append(' <img src="images/loader_small_grey.gif" style="vertical-align: middle" />');

				//do the ajax call to unsuspend the user
				var user_id  	 = $("#vu_details").data("userid");
				var csrf_token   = $("#vu_details").data("csrftoken");
				var current_user = [{ name : "entry_" + user_id, value : "1"}];
					
				//do the ajax call to suspend the users
				axios.post('change_user_status.php', {
					action: 'suspend',
					no_session_msg: '1',
					csrf_token: csrf_token,
					selected_users: current_user
				})
				.then(function (response) {
					if(response.data.status == 'ok'){
						$("#vu_action_suspend").data("processing",false);
						$("#vu_action_suspend").html('<span class="icon-unlocked"></span>Unblock');
						$("#vu_profile").append('<div id="vu_suspended" style="display: none">This user is currently being <span>SUSPENDED</span></div>');
						$("#vu_suspended").fadeIn();
					}else{
						Swal.fire({
							width: '30%',
							position: 'center',
							icon: 'error',
							title: 'Error. Unable to complete the task.',
							html: response.data,
							showConfirmButton: false,
							showCancelButton: true,
							cancelButtonText: 'Close',
							allowOutsideClick: true
						});
					}
				})
				.catch(function (error) {
					Swal.fire({
						width: '30%',
						position: 'center',
						icon: 'error',
						title: 'Error. Unable to complete the task.',
						html: error,
						showConfirmButton: false,
						showCancelButton: true,
						cancelButtonText: 'Close',
						allowOutsideClick: true
					});
				});
			}
		}

		return false;
	});
	
	//open the change password dialog
	$("#vu_action_password").on('click',function(){	
		
		var current_user_id = $("#vu_details").data("userid");
		var csrf_token  	= $("#vu_details").data("csrftoken");
		
		Swal.fire({
			title: 'Change User Password',
			html: $("#dialog-change-password").html(),
			width: '30%',
			customClass: {
				footer: 'swal2-footer-info',
				title: 'swal2-title-warning'
			},
			didOpen: () => {
				$("#dialog-change-password-input1").trigger("focus");
			},
			confirmButtonText: 'Save Password',
			cancelButtonText: 'Cancel',
			showCancelButton: true,
			showConfirmButton: true,
			showLoaderOnConfirm: true,
			allowOutsideClick: () => !Swal.isLoading(),
			preConfirm: (tagnames) => {
				var password_1 = $.trim($("#dialog-change-password-input1").val());
				var password_2 = $.trim($("#dialog-change-password-input2").val());
				var send_login_info = 0;

				if($("#dialog-change-password-send-login").prop("checked") == true){
					send_login_info = 1;
				}

				if(password_1 == "" || password_2 == ""){
					Swal.showValidationMessage('Error: Please fill in both password fields!');
					return false;
				}else if(password_1 != password_2){
					Swal.showValidationMessage('Error: Please enter the same password in both fields!');
					return false;
				}

				return axios.post('change_password.php', {
					np: password_1,
					user_id: current_user_id,
					csrf_token: csrf_token,
					send_login: send_login_info
				})
				.then(function (response) {
					if(response.data.status == 'ok'){
						Swal.fire({
							toast: true,
							position: 'center',
							icon: 'success',
							title: 'Password changed.',
							showConfirmButton: false,
							timer: 2000
						});
						
						return response;
					}else{
						Swal.showValidationMessage('Error: Unable to process. Please try again later.');
					}
				})
				.catch(function (error) {
					Swal.showValidationMessage("Error: " + error);
				});
			}
		});

		return false;
	});
	
});